(()=>{"use strict";var e={834:(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.BlameViewProvider=void 0;const o=i(398),s=i(414),r=i(268),n=i(368),a=i(477).loadMessageBundle(i(928).join(__dirname,"blameViewProvider.ts"));class c{constructor(e,t){this._owner=e,this._gitService=t,this._disposables=[],this._disposables.push(o.languages.registerHoverProvider({scheme:"file"},this))}dispose(){o.Disposable.from(...this._disposables).dispose()}provideHover(e,t){if(!this._owner.isAvailable(e,t)||this._gitService.lineIsUncommit(this._owner.blame))return;let i=new o.MarkdownString(`*\`${a(0,null)}\`*\r\n>\r\n`);return i.appendCodeblock(this._owner.blame?.stat??"","txt"),i.appendMarkdown(">"),new o.Hover(i)}}t.BlameViewProvider=class{constructor(e,t,i){this._gitService=i,this._enabled=!1,this._decoration=o.window.createTextEditorDecorationType({after:{color:new o.ThemeColor("githd.blameView.info"),fontStyle:"italic"}}),this.enabled=t.configuration.blameEnabled,this._statProvider=new c(this,this._gitService),this.initUpdateBlame(),e.subscriptions.push(o.languages.registerHoverProvider({scheme:"file"},this),this._statProvider,this._decoration),e.subscriptions.push(o.window.onDidChangeTextEditorSelection((e=>{this._onDidChangeSelection(e.textEditor)}),null,e.subscriptions)),e.subscriptions.push(o.window.onDidChangeActiveTextEditor((e=>{e&&this._onDidChangeActiveTextEditor(e)}),null,e.subscriptions)),e.subscriptions.push(o.workspace.onDidChangeTextDocument((e=>{this._onDidChangeTextDocument((0,n.getTextEditor)(e.document))}),null,e.subscriptions)),o.commands.executeCommand("setContext","showBlame",t.configuration.blameEnabled),e.subscriptions.push(t.onDidChangeConfiguration((e=>{this.enabled=e.blameEnabled,o.commands.executeCommand("setContext","showBlame",this._enabled),o.window.activeTextEditor&&(e.blameEnabled?this._onDidChangeTextDocument(o.window.activeTextEditor):this._clear(o.window.activeTextEditor))}),null,e.subscriptions))}set enabled(e){this._enabled!==e&&(r.Tracer.info(`Blame view: set enabled ${e}`),this._enabled=e)}get balmeEnabled(){return this._enabled}get blame(){return this._blame}provideHover(e,t){if(!this.isAvailable(e,t))return;const i=this._blame;return i&&!this._gitService.lineIsUncommit(i)?new Promise((async e=>{const t=await this._gitService.getGitRepo(i.file.fsPath),s=i.hash,a=`[*${s}*](command:githd.openCommit?${encodeURIComponent(JSON.stringify([t,s,i.file]))} "Click to see commit details")`;let c=i.subject;const[l,h]=(0,n.getPullRequest)(i.subject);l&&(c=c.substring(0,h)+`[*${l}*](${t?.remoteUrl}/pull/${l.substring(1)})`+c.substring(h+l.length)),r.Tracer.verbose(`Blame view: ${a}`);const d=`\n${a}\n*\`${i.author}\`*\n*\`${i.email}\`*\n*\`(${i.date})\`*\n${c}\n${i.body}\n>`;let u=new o.MarkdownString(d);return u.isTrusted=!0,e(new o.Hover(u))})):void 0}isAvailable(e,t){return!(!this._enabled||!this._blame?.hash||e.isDirty||t.line!=this._blame?.line||t.character<e.lineAt(this._blame.line).range.end.character||e.uri!==this._blame?.file)}async _onDidChangeSelection(e){if(!e)return void r.Tracer.info("_onDidChangeSelection with null or undefined editor");const t=e.document.uri;if(!this._enabled||"file"!==t.scheme||e.document.isDirty)return;r.Tracer.verbose("Blame view: onDidChangeSelection");const i=e.selection.active.line;this._blame&&i==this._blame.line&&t===this._blame.file||(this._clear(e),clearTimeout(this._debouncing),this._debouncing=setTimeout((()=>this._update(e)),250))}async _onDidChangeActiveTextEditor(e){if(!e)return void r.Tracer.info("_onDidChangeActiveTextEditor with null or undefined editor");const t=e.document.uri;this._enabled&&"file"===t.scheme&&!e.document.isDirty&&(r.Tracer.verbose("Blame view: onDidChangeActiveTextEditor"),this._clear(e),this._update(e))}initUpdateBlame(){const e=o.window.activeTextEditor;this._enabled&&e&&"file"===e.document.uri.scheme&&!e.document.isDirty&&this._update(e)}async _onDidChangeTextDocument(e){if(!e)return;const t=e.document.uri;this._enabled&&"file"===t.scheme&&(r.Tracer.verbose(`Blame view: onDidChange.TextDocument. isDirty ${e.document.isDirty}`),this._clear(e),e.document.isDirty||this._update(e))}async _update(e){const t=e.document.uri,i=e.selection.active.line;if(r.Tracer.verbose(`Try to update blame. ${t.fsPath}: ${i}`),this._blame=await this._gitService.getBlameItem(t,i),(t!==e.document.uri||i!=e.selection.active.line||e.document.isDirty)&&(r.Tracer.info(`This update is outdated. ${t.fsPath}: ${i}, dirty ${e.document.isDirty}`),this._blame=void 0),!this._blame)return;let n="    ";this._gitService.lineIsUncommit(this._blame)?n+=`You, ${s.GitService.NotCommitted}`:n+=`${this._blame.author} [${this._blame.relativeDate}] • ${this._blame.subject}`;const a={range:new o.Range(i,Number.MAX_SAFE_INTEGER,i,Number.MAX_SAFE_INTEGER),renderOptions:{after:{contentText:n}}};e.setDecorations(this._decoration,[a])}_clear(e){this._blame=void 0,e.setDecorations(this._decoration,[])}}},293:(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.ClickableProvider=void 0;const o=i(398),s=i(268),r=i(368);t.ClickableProvider=class{constructor(e){this._scheme=e,this._clickables=[],this._disposables=[],this._lastClickedItems=[],this._decoration=o.window.createTextEditorDecorationType({cursor:"pointer",textDecoration:"underline"}),this._disposables.push(o.languages.registerHoverProvider({scheme:e},this)),this._disposables.push(this._decoration),this._disposables.push(o.window.onDidChangeTextEditorSelection((t=>{let i=t.textEditor;if(i&&i.document.uri.scheme===e&&t.kind===o.TextEditorSelectionChangeKind.Mouse){const e=t.selections[0].anchor,o=this._clickables.find((t=>t.range.contains(e)));o&&this._onClicked(o,i)}}),null,this._disposables)),this._disposables.push(o.window.onDidChangeActiveTextEditor((t=>{t&&t.document.uri.scheme===e&&this._setDecorations(t)}),null,this._disposables)),this._disposables.push(o.workspace.onDidChangeTextDocument((t=>{t.document.uri.scheme===e&&this._setDecorations((0,r.getTextEditor)(t.document))}),null,this._disposables))}async provideHover(e,t){const i=this._clickables.find((e=>e.range.contains(t)));if(i&&i.getHoverMessage){const e=await i.getHoverMessage();return new o.Hover(e)}}addClickable(e){this._clickables.push(e)}removeClickable(e){e&&[this._clickables,this._lastClickedItems].forEach((t=>{const i=t.findIndex((t=>t.range.isEqual(e)));-1!==i&&t.splice(i,1)}))}clear(){this._clickables=[],this._lastClickedItems=[]}dispose(){this._disposables.forEach((e=>e.dispose()))}_onClicked(e,t){if(e.clickedDecorationType){t.setDecorations(e.clickedDecorationType,[e.range]);const i=this._lastClickedItems.findIndex((t=>t.clickedDecorationType===e.clickedDecorationType));-1!==i&&this._lastClickedItems.splice(i,1),this._lastClickedItems.push(e)}e.callback()}_setDecorations(e){e&&e.document.uri.scheme===this._scheme?(this._lastClickedItems.forEach((t=>{t.clickedDecorationType&&e.setDecorations(t.clickedDecorationType,[t.range])})),e.setDecorations(this._decoration,this._clickables.map((e=>e.range)))):s.Tracer.warning(`Clickable: try to set decoration to wrong scheme: ${e?e.document.uri.scheme:""}`)}}},875:function(e,t,i){var o=this&&this.__decorate||function(e,t,i,o){var s,r=arguments.length,n=r<3?t:null===o?o=Object.getOwnPropertyDescriptor(t,i):o;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)n=Reflect.decorate(e,t,i,o);else for(var a=e.length-1;a>=0;a--)(s=e[a])&&(n=(r<3?s(n):r>3?s(t,i,n):s(t,i))||n);return r>3&&n&&Object.defineProperty(t,i,n),n};Object.defineProperty(t,"__esModule",{value:!0}),t.CommandCenter=void 0;const s=i(928),r=i(613),n=i(398),a=i(153),c=i(414),l=i(268),h=i(477).loadMessageBundle(i(928).join(__dirname,"commands.ts"));function d(e,t){return e.with({scheme:"git",path:e.path,query:JSON.stringify({path:e.fsPath,ref:t})})}async function u(e,t,i){const o=(await e.getRefs(t)).map((e=>{let t;return e.type===c.GitRefType.Head?t=e.commit:e.type===c.GitRefType.Tag?t=h(0,null,e.commit):e.type===c.GitRefType.RemoteHead&&(t=h(1,null,e.commit)),{label:e.name||e.commit,description:t}}));return i&&o.unshift(new m),o}class m{constructor(){this.label=h(2,null),this.description="",this.openShaTextBox=!0}}async function g(e){const t=e.getGitRepos();if(0===t.length)return;if(1===t.length)return t[0];const i=t.map((e=>({label:s.basename(e.root),description:e.root,repo:e}))),o=await n.window.showQuickPick(i,{placeHolder:h(3,null)});return o?.repo}const f=[];function p(e){return function(t,i,o){if("function"!=typeof o.value)throw new Error("not supported");f.push({id:e,method:o.value})}}class _{constructor(e,t,i,o,s,r){this._model=t,this._gitService=i,this._historyView=o,this._infoView=s,this._blameViewProvider=r,e.subscriptions.push(...f.map((({id:e,method:t})=>n.commands.registerCommand(e,((...e)=>{Promise.resolve(t.apply(this,e))})))))}async clear(){l.Tracer.verbose("Command: githd.clear"),this._model.filesViewContext=void 0,await n.commands.executeCommand("githd.refresh"),n.commands.executeCommand("setContext","history.view.show",!1)}async viewHistory(){l.Tracer.verbose("Command: githd.viewHistory");const e=await g(this._gitService);e&&this._viewHistory({repo:e,branch:""})}async openCurrent(e){if("githd.openCommitInfo"===e.command.command)n.commands.executeCommand("githd.openCommitInfo",e.command.arguments[0]??"");else{const t=n.Uri.file(e.resourceUri.path.substring(1));n.commands.executeCommand("vscode.open",t)}}async copyFilePath(e){const t=n.Uri.file(e.resourceUri.path.substring(1));n.commands.executeCommand("copyFilePath",t)}async copyRelativeFilePath(e){const t=n.Uri.file(e.resourceUri.path.substring(1));n.commands.executeCommand("copyRelativeFilePath",t)}async viewFileHistory(e=n.window.activeTextEditor?.document?.uri){if(l.Tracer.verbose("Command: githd.viewFileHistory"),!e)return;let t=await this._gitService.getGitRepo(e.fsPath);return t?this._viewHistory({specifiedPath:e,repo:t,branch:""}):void 0}async viewFolderHistory(e){return l.Tracer.verbose("Command: githd.viewFolderHistory"),this.viewFileHistory(e)}async viewLineHistory(e=n.window.activeTextEditor?.document?.uri){if(l.Tracer.verbose("Command: githd.viewLineHistory"),!e)return;let t=await this._gitService.getGitRepo(e.fsPath);if(!t)return;let i=n.window.activeTextEditor?.selection?.active?.line;return i?(i++,this._viewHistory({specifiedPath:e,line:i,repo:t,branch:""})):void 0}async showGitBlame(){n.workspace.getConfiguration().update("githd.blameView.enabled",!this._blameViewProvider.balmeEnabled)}async viewAllHistory(){l.Tracer.verbose("Command: githd.viewAllHistory");let e=this._model.historyViewContext??{repo:this._gitService.getGitRepos()[0],branch:""};return this._viewHistory(e,!0)}async viewBranchHistory(e){l.Tracer.verbose("Command: githd.viewBranchHistory");let t,i=h(4,null);if(e){t=e.repo;const o=this._model.historyViewContext?.specifiedPath;o&&(i=h(5,null,s.basename(o.fsPath)))}else{const e=await g(this._gitService);if(!e)return;t=e}i+=` (${t.root})`,n.window.showQuickPick(u(this._gitService,t),{placeHolder:i}).then((i=>{i&&(e?(e.branch=i.label,this._viewHistory(e)):this._viewHistory({branch:i.label,repo:t}))}))}async viewAuthorHistory(){l.Tracer.verbose("Command: githd.viewAuthorHistory"),r(this._model.historyViewContext,"history view context should exist");const e=this._model.historyViewContext;let t=h(6,null);n.window.showQuickPick(async function(e,t){let i=await e.getAuthors(t);return i.unshift({name:"All",email:""}),i.map((e=>({label:e.name,description:e.email})))}(this._gitService,e.repo),{placeHolder:t}).then((e=>{if(e){const t=e.description;let i=this._model.historyViewContext;i&&(i.author=t,this._viewHistory(i))}}))}async viewStashes(){l.Tracer.verbose("Command: githd.viewStashes");const e=await g(this._gitService);e&&this._viewHistory({repo:e,isStash:!0,branch:""})}async diffBranch(){l.Tracer.verbose("Command: githd.diffBranch");const e=await g(this._gitService);e&&this._diffSelections({repo:e})}async diffFile(e){return l.Tracer.verbose("Command: githd.diffFile"),this._diffPath(e)}async diffFolder(e){return l.Tracer.verbose("Command: githd.diffFolder"),this._diffPath(e)}async inputRef(){l.Tracer.verbose("Command: githd.inputRef");const e=await g(this._gitService);e&&n.window.showInputBox({placeHolder:h(7,null)}).then((t=>this._model.filesViewContext={rightRef:t?.trim(),repo:e}))}async openCommit(e,t,i){l.Tracer.verbose("Command: githd.openCommit"),this._model.filesViewContext={rightRef:t,repo:e,specifiedPath:i}}async openCommittedFile(e){l.Tracer.verbose("Command: githd.openCommittedFile");let t=this._model.filesViewContext?.rightRef,i=t+"~",o=t;this._model.filesViewContext?.leftRef&&(i=this._model.filesViewContext.leftRef,o=`${i} .. ${t}`),n.commands.executeCommand("vscode.diff",d(e.oldFileUri,i),d(e.fileUri,t),o+" | "+s.basename(e.gitRelativePath),{preview:!0})}async openCommitInfo(e){l.Tracer.verbose("Command: githd.openCommitInfo"),this._infoView.update(e),n.workspace.openTextDocument(a.InfoViewProvider.defaultUri).then((e=>n.window.showTextDocument(e,{preview:!0,preserveFocus:!0}).then((()=>n.commands.executeCommand("cursorTop")))))}async diffUncommittedFile(e=n.window.activeTextEditor?.document?.uri){if(!e)return;l.Tracer.verbose("Command: githd.diffUncommittedFile");const t=await this._gitService.getGitRepo(e.fsPath);t&&n.window.showQuickPick(u(this._gitService,t),{placeHolder:h(8,null,s.basename(e.path))}).then((async t=>{if(t)return await n.commands.executeCommand("vscode.diff",d(e,t.label),e,`${t.label} .. Uncommitted (${s.basename(e.path)})`,{preview:!0})}))}async setExpressMode(){l.Tracer.verbose("Command: githd.setExpressMode"),this._historyView.express=!this._historyView.express}async _viewHistory(e,t=!1){this._historyView.loadAll=t,await this._model.setHistoryViewContext(e)}async _diffPath(e){if(e){const t=await this._gitService.getGitRepo(e.fsPath);t&&this._diffSelections({repo:t,specifiedPath:e})}}async _diffSelections({repo:e,specifiedPath:t}){const i=await u(this._gitService,e,!0),o=await async function(e,t){const i=(await e.getRefs(t)).filter((e=>e.type!=c.GitRefType.Tag)),o=i.filter((e=>e.type!=c.GitRefType.RemoteHead));let s=[];return o.forEach((e=>{i.forEach((t=>{e.name!=t.name&&e.commit!=t.commit&&s.push({label:`${e.name||e.commit} .. ${t.name||t.commit}`})}))})),s}(this._gitService,e),s=[...i,...o],r=await this._gitService.getCurrentBranch(e),a=h(9,null,r);n.window.showQuickPick(s,{placeHolder:a}).then((async i=>{if(!i)return;let o=await async function(e,t){return e.openShaTextBox?await n.window.showInputBox({prompt:t}):e.label}(i,h(10,null,r)),s=r;if(o){if(-1!=o.indexOf("..")){const e=o.split("..");o=e[0].trim(),s=e[1].trim()}this._model.filesViewContext={repo:e,leftRef:o,rightRef:s,specifiedPath:t}}}))}}o([p("githd.clear")],_.prototype,"clear",null),o([p("githd.viewHistory")],_.prototype,"viewHistory",null),o([p("githd.openCurrent")],_.prototype,"openCurrent",null),o([p("githd.copyFilePath")],_.prototype,"copyFilePath",null),o([p("githd.copyRelativeFilePath")],_.prototype,"copyRelativeFilePath",null),o([p("githd.viewFileHistory")],_.prototype,"viewFileHistory",null),o([p("githd.viewFolderHistory")],_.prototype,"viewFolderHistory",null),o([p("githd.viewLineHistory")],_.prototype,"viewLineHistory",null),o([p("githd.showBlame")],_.prototype,"showGitBlame",null),o([p("githd.viewAllHistory")],_.prototype,"viewAllHistory",null),o([p("githd.viewBranchHistory")],_.prototype,"viewBranchHistory",null),o([p("githd.viewAuthorHistory")],_.prototype,"viewAuthorHistory",null),o([p("githd.viewStashes")],_.prototype,"viewStashes",null),o([p("githd.diffBranch")],_.prototype,"diffBranch",null),o([p("githd.diffFile")],_.prototype,"diffFile",null),o([p("githd.diffFolder")],_.prototype,"diffFolder",null),o([p("githd.inputRef")],_.prototype,"inputRef",null),o([p("githd.openCommit")],_.prototype,"openCommit",null),o([p("githd.openCommittedFile")],_.prototype,"openCommittedFile",null),o([p("githd.openCommitInfo")],_.prototype,"openCommitInfo",null),o([p("githd.diffUncommittedFile")],_.prototype,"diffUncommittedFile",null),o([p("githd.setExpressMode")],_.prototype,"setExpressMode",null),t.CommandCenter=_},586:(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});const o=i(398),s=i(210),r=i(477).loadMessageBundle(i(928).join(__dirname,"docurationProvider.ts"));t.default=class{constructor(){this.onDidChangeDecorationEmitter=new o.EventEmitter,this.onDidChangeFileDecorations=this.onDidChangeDecorationEmitter.event,this.disposable=o.Disposable.from(o.window.registerFileDecorationProvider(this))}provideFileDecoration(e){if(e.scheme!==s.CommittedFileItem.fileScheme)return;let t="";try{t=JSON.parse(e.query).status}catch(e){}switch(t){case"U":return this.getDecorator("U","gitDecoration.untrackedResourceForeground");case"A":return this.getDecorator("A","gitDecoration.addedResourceForeground");case"D":return this.getDecorator("D","gitDecoration.deletedResourceForeground");case"M":return this.getDecorator("M","gitDecoration.modifiedResourceForeground");case"R":return this.getDecorator("R","gitDecoration.renamedResourceForeground")}}getStatusText(e){switch(e){case"M":return r(0,null);case"A":return r(1,null);case"D":return r(2,null);case"R":return r(3,null);case"U":return r(4,null);default:return""}}getDecorator(e,t){return new o.FileDecoration(e,this.getStatusText(e),new o.ThemeColor(t))}dispose(){this.disposable.dispose()}}},210:(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.ExplorerViewProvider=t.CommittedFileItem=void 0;const o=i(928),s=i(896),r=i(398);class n extends r.TreeItem{constructor(e,t){super(t),this.parent=void 0,this.contextValue="info",this.command={title:"",command:"githd.openCommitInfo",arguments:[e]},this.iconPath=new r.ThemeIcon("info")}}class a extends r.TreeItem{constructor(e,t,i){super(i),this.parent=e,this.file=t,this.command={title:"",command:"githd.openCommittedFile",arguments:[this.file]},this.resourceUri=this.getResourceUri(t)}getResourceUri(e){return e.fileUri.with({scheme:a.fileScheme,query:JSON.stringify({status:e.status[0].toUpperCase()})})}}t.CommittedFileItem=a,a.fileScheme="git-history-diff-contents";class c extends r.TreeItem{constructor(e,t,i,o){super(i),this._parent=e,this._gitRelativePath=t,this._subFolders=[],this._files=[],this.parent=this._parent,this.gitRelativePath=this._gitRelativePath,this.contextValue="folder",this.iconPath=o,this.collapsibleState=r.TreeItemCollapsibleState.Expanded}get subFolders(){return this._subFolders}set subFolders(e){this._subFolders=e}get files(){return this._files}set files(e){this._files=e}get infoItem(){return this._infoItem}set infoItem(e){this._infoItem=e}}function l(e){const t=o.basename(e);let i=o.dirname(e);return"."===i&&(i=""),t+"  •  "+i}function h(e,t){return new a(e,t,l(t.gitRelativePath))}function d(e,t,i=""){const s=i?o.relative(i,t.gitRelativePath).split(/\\|\//):t.gitRelativePath.split("/");let r=i,n=e,l=0;for(;l<s.length-1;++l){r+=s[l]+"/";let e=n.subFolders.find((e=>e.label===s[l]));e||(e=new c(n,r,s[l]),n.subFolders.push(e)),n=e}n.files.push(new a(n,t,s[l]))}function u(e,t,i){i?t.forEach((t=>d(e,t))):e.files.push(...t.map((t=>h(e,t))))}function m(e,t){e.files.push(...t.files.map((t=>(t.label=l(o.relative(e.gitRelativePath,t.file.gitRelativePath).replace(/\\/g,"/")),t)))),t.subFolders.forEach((t=>m(e,t))),t.files=[],t.subFolders=[]}function g(e){e.subFolders.forEach((e=>g(e)));const t=e.files;e.files=[],t.forEach((t=>d(e,t.file,e.gitRelativePath)))}function f(e,t){e&&(e.collapsibleState=t,e.subFolders.forEach((e=>f(e,t))))}t.ExplorerViewProvider=class{constructor(e,t,i){this._gitService=i,this._onDidChange=new r.EventEmitter,this._treeRoot=[],this.onDidChangeTreeData=this._onDidChange.event,r.commands.executeCommand("setContext","isExpanded",!0),e.subscriptions.push(r.window.registerTreeDataProvider("committedFiles",this),r.commands.registerCommand("githd.showFilesWithFolder",(e=>this._showFilesWithFolder(e))),r.commands.registerCommand("githd.showFilesWithoutFolder",(e=>this._showFilesWithoutFolder(e))),r.commands.registerCommand("githd.collapseFolder",(e=>this._setCollapsibleStateOnAll(e,r.TreeItemCollapsibleState.Collapsed))),r.commands.registerCommand("githd.expandFolder",(e=>this._setCollapsibleStateOnAll(e,r.TreeItemCollapsibleState.Expanded))),r.commands.registerCommand("githd.refresh",(()=>this._onDidChange.fire(void 0))),r.commands.registerCommand("githd.viewFileHistoryFromTree",(e=>t.setHistoryViewContext(this._context?{repo:this._context.repo,specifiedPath:e.file.fileUri,branch:""}:void 0))),r.commands.registerCommand("githd.viewFolderHistoryFromTree",(e=>t.setHistoryViewContext(this._context?{repo:this._context.repo,specifiedPath:r.Uri.file(o.join(this._context.repo.root,e.gitRelativePath)),branch:""}:void 0))),this._onDidChange),e.subscriptions.push(t.onDidChangeFilesViewContext((e=>{this._context=e,this._update()}),null,e.subscriptions)),this._context=t.filesViewContext,this._withFolder=t.configuration.withFolder,r.commands.executeCommand("setContext","isShowFilesWithFolder",this._withFolder),this._update()}getTreeItem(e){return e}getChildren(e){if(!e)return this._treeRoot;let t=[],i=e;return i&&(t=[...i.subFolders,...i.files],i.infoItem&&t.push(i.infoItem)),t}getParent(e){return e.parent}get commitOrStashString(){return this._context?.isStash?"Stash":"Commit"}async _update(){if(this._treeRoot=[],!this._context)return void this._onDidChange.fire(void 0);const e=this._context.leftRef,t=this._context.rightRef,i=this._context.specifiedPath,o=this._context.focusedLineInfo;if(!t)return void this._onDidChange.fire(void 0);const s=await this._gitService.getCommittedFiles(this._context.repo,t,e,this._context.isStash);e||await this._buildCommitInfo(t),e||i?e&&!i?this._buildDiffBranchTree(s,e,t):!e&&i?await this._buildPathSpecifiedCommitTree(s,i,t,o):await this._buildPathSpecifiedDiffBranchTree(s,this._context):this._buildCommitTree(s,t),this._onDidChange.fire(void 0)}async _buildCommitInfo(e){await this._treeRoot.push(new n(await this._gitService.getCommitDetails(this._context?.repo,e,this._context?.isStash),`${this.commitOrStashString} Info`))}_buildCommitTree(e,t){this._buildCommitFolder(`${this.commitOrStashString} ${t}   (${e.length} files changed)`,e)}_buildDiffBranchTree(e,t,i){this._buildCommitFolder(`Diffs between ${t} and ${i}   (${e.length} files)`,e)}async _buildPathSpecifiedCommitTree(e,t,i,o){await this._buildFocusFolder("Focus",e,t,o),this._buildCommitTree(e,i)}async _buildPathSpecifiedDiffBranchTree(e,t){t.specifiedPath&&await this._buildFocusFolder(`${t.leftRef} .. ${t.rightRef}`,e,t.specifiedPath)}_buildCommitFolder(e,t){let i=new c(void 0,"",e,new r.ThemeIcon("type-hierarchy"));u(i,t,this._withFolder),this._treeRoot.push(i)}async _buildFocusFolder(e,t,i,o){let a=new c(void 0,"",e,new r.ThemeIcon("type-hierarchy"));const l=await this._gitService.getGitRelativePath(i);if(s.lstatSync(i.fsPath).isFile()){o&&(a.infoItem=new n(o,"line diff"));let e=t.find((e=>e.gitRelativePath===l));e&&a.files.push(h(a,e))}else{let e=[];t.forEach((t=>{l&&0===t.gitRelativePath.search(l)&&e.push(t)})),u(a,e,this._withFolder)}(a.files.length+a.subFolders.length>0||a.infoItem)&&this._treeRoot.push(a)}_showFilesWithFolder(e){e?(g(e),this._onDidChange.fire(e)):(this._withFolder=!0,this._update(),r.commands.executeCommand("setContext","isShowFilesWithFolder",!0))}_showFilesWithoutFolder(e){e?(e.subFolders?.forEach((t=>m(e,t))),e.subFolders=[],this._onDidChange.fire(e)):(this._withFolder=!1,this._update(),r.commands.executeCommand("setContext","isShowFilesWithFolder",!1))}_setCollapsibleStateOnAll(e,t){let i;if(e?(i=e.parent,e.collapsibleState=t,e.subFolders.forEach((e=>f(e,t)))):(r.commands.executeCommand("setContext","isExpanded",t===r.TreeItemCollapsibleState.Expanded),this._treeRoot.forEach((e=>{e instanceof c&&f(e,t)}))),i){const e=i.subFolders;i.subFolders=[],this._onDidChange.fire(i),setTimeout((()=>{i&&(i.subFolders=e,this._onDidChange.fire(i))}),250)}else{const e=this._treeRoot;this._treeRoot=[],this._onDidChange.fire(void 0),setTimeout((()=>{this._treeRoot=e,this._onDidChange.fire(void 0)}),250)}}}},414:(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.GitService=t.GitRefType=void 0;const o=i(928),s=i(896),r=i(857),n=i(398),a=i(317),c=i(268),l=i(368),h="[githd-es]",d="[githd-fs]";function u(e){return e=o.normalize(e),"win32"==r.platform()&&(e=e.toLocaleLowerCase()),e.endsWith(o.sep)||(e+=o.sep),e}var m;!function(e){e[e.Head=0]="Head",e[e.RemoteHead=1]="RemoteHead",e[e.Tag=2]="Tag"}(m=t.GitRefType||(t.GitRefType={}));class g{constructor(e,t,i,o){this._repo=e,this.gitRelativePath=t,this.gitRelativeOldPath=i,this.status=o}get fileUri(){return n.Uri.file(o.join(this._repo.root,this.gitRelativePath))}get oldFileUri(){return n.Uri.file(o.join(this._repo.root,this.gitRelativeOldPath))}}function f(e){return e.replace(/\r?\n|\r/g," ")}class p{constructor(e){this._gitRepos=[],this._onDidChangeGitRepositories=new n.EventEmitter,e.subscriptions.push(this._onDidChangeGitRepositories);let t=n.workspace.getConfiguration("git").get("path")??"";if(t)try{(0,a.execSync)(t)}catch(e){t="git"}else t="git";this._gitPath=t}get onDidChangeGitRepositories(){return this._onDidChangeGitRepositories.event}updateGitRoots(e){this._gitRepos=[],n.commands.executeCommand("setContext","hasGitRepo",!1),this._onDidChangeGitRepositories.fire([]);const t=Date.now();let i=0;e&&e.forEach((e=>{i+=this._scanFolder(e.uri.fsPath,!0)})),c.Tracer.info(`updateGitRoots: ${e?.length} wsFolders ${i} subFolders (${Date.now()-t}ms)`)}getGitRepos(){return this._gitRepos}async getGitRepo(e){s.statSync(e).isFile()&&(e=o.dirname(e)),e=u(e);let t=this._gitRepos.find((t=>e.startsWith(t.root)));if(t)return t;let i=(await this._exec(["rev-parse","--show-toplevel"],e)).trim();if(i&&(i=u(i),-1===this._gitRepos.findIndex((e=>e.root==i)))){const o=await this._getRemoteUrl(e);t={root:i,remoteUrl:o},this._gitRepos.some((e=>e.root===i&&e.remoteUrl===o))||this._gitRepos.push(t),n.commands.executeCommand("setContext","hasGitRepo",!0),this._onDidChangeGitRepositories.fire(this.getGitRepos())}return t}async getGitRelativePath(e){if(!e)return;const t=await this.getGitRepo(e.fsPath);if(!t)return;let i=o.relative(t.root,e.fsPath).replace(/\\/g,"/");return""===i?".":i}async getCurrentBranch(e){if(e)return(await this._exec(["rev-parse","--abbrev-ref","HEAD"],e.root)).trim()}async getCommitsCount(e,t,i){if(!e)return 0;let o=["rev-list","--simplify-merges","--count",t];return i&&o.push(`--author=${i}`),parseInt(await this._exec(o,e.root))}async getRefs(e){return e?(await this._exec(["for-each-ref","--format=%(refname) %(objectname:short)"],e.root)).trim().split("\n").filter((e=>!!e)).map((e=>{let t;return(t=/^refs\/heads\/([^ ]+) ([0-9a-f]+)$/.exec(e))?{name:t[1],commit:t[2],type:m.Head}:(t=/^refs\/remotes\/([^/]+)\/([^ ]+) ([0-9a-f]+)$/.exec(e))?{name:`${t[1]}/${t[2]}`,commit:t[3],type:m.RemoteHead}:(t=/^refs\/tags\/([^ ]+) ([0-9a-f]+)$/.exec(e))?{name:t[1],commit:t[2],type:m.Tag}:null})).filter((e=>!!e)):[]}async getCommittedFiles(e,t,i,o){if(!e)return[];let s=["show","--format=%h","--name-status",t];i?s=["diff","--name-status",`${i}..${t}`]:o&&s.unshift("stash");const r=await this._exec(s,e.root);let n=[];return r.split(/\r?\n/g).forEach(((t,i)=>{if(t){let i,o,s=t.split(/\t/g);if(s.length<2)return;const r=s[0][0].toLocaleUpperCase();switch(r){case"M":case"A":case"D":o=s[1],i=s[1];break;case"R":case"C":o=s[1],i=s[2];break;default:throw new Error("Cannot parse "+s)}n.push(new g(e,i,o,r))}})),n}async getLogEntries(e,t,i,o,s,r,n,a,l){if(c.Tracer.info(`Get entries. repo: ${e.root}, express: ${t}, start: ${i}, count: ${o}, branch: ${s}, isStash: ${r}, file: ${n?.fsPath}, line: ${a}, author: ${l}`),!e)return[];let u,m=h;r&&(m+="%gd:"),function(e){e[e.subject=0]="subject",e[e.hash=1]="hash",e[e.ref=2]="ref",e[e.author=3]="author",e[e.email=4]="email",e[e.timestamp=5]="timestamp",e[e.date=6]="date",e[e.relativeDate=7]="relativeDate",e[e.additional=8]="additional",e[e.total=9]="total"}(u||(u={})),m+=`%s${d}%h${d}%d${d}%aN${d}%ae${d}%ct${d}%cd${d}%cr${d}`;let g=[`--format=${m}`,"--date=local"];if(t||a||g.push("--shortstat"),r)g.unshift("stash","list");else if(g.unshift("log",`--skip=${i}`,`--max-count=${o}`,"--date-order","--simplify-merges",s),l&&g.push(`--author=${l}`),n){const e=await this.getGitRelativePath(n)??".";a?g.push(`-L ${a},${a}:${e}`,"--"):g.push("--follow","--",e)}else g.push("--");const p=await this._exec(g,e.root);let _=[];return p.split(h).forEach((e=>{if(!e)return;let t,i,o,s,r,n,c,l,h,m;e.split(d).forEach(((e,d)=>{switch(d%u.total){case u.subject:t=f(e);break;case u.hash:i=e;break;case u.ref:o=e;break;case u.author:s=e;break;case u.email:r=e;break;case u.timestamp:n=parseInt(e);break;case u.date:c=e;break;case u.relativeDate:l=e;break;case u.additional:a?m=e.trim():h=e.trim(),_.push({subject:t,hash:i,ref:o,author:s,email:r,timestamp:n,date:c,relativeDate:l,stat:h,lineInfo:m})}}))})),_}async getCommitDetails(e,t,i){if(!e)return"";const o=i?"Stash:         %H %nAuthor:        %aN <%aE> %nAuthorDate:    %ad %n%n%s %n":"Commit:        %H %nAuthor:        %aN <%aE> %nAuthorDate:    %ad %nCommit:        %cN <%cE> %nCommitDate:    %cd %n%n%s %n";let s=await this._exec(["show",`--format=${o}`,"--no-patch","--date=local",t],e.root);const r=(await this._exec(["show","--format=%b","--no-patch",t],e.root)).trim();return r&&(s+=r+"\r\n\r\n"),s+="-----------------------------\r\n\r\n",s+=await this._exec(["show","--format=","--stat",t],e.root),s}async getAuthors(e){return e?(await this._exec(["shortlog","-se","HEAD"],e.root)).trim().split(/\r?\n/g).map((e=>{let t=(e=e.trim()).search(/ |\t/);return t=(e=e.substr(t+1).trim()).indexOf("<"),{name:e.substring(0,t),email:e.substring(t+1,e.length-1)}})):[]}async getBlameItem(e,t){const i=await this.getGitRepo(e.fsPath);if(!i)return;const o=e.fsPath,s=await this._exec(["blame",`${o}`,"-L",`${t+1},${t+1}`,"--incremental","--root"],i.root);let r="",n="",a="",c="",h="",u=0;s.split(/\r?\n/g).forEach(((e,t)=>{if(0==t)r=e.split(" ")[0];else{const t=e.split(" ")[0],i=e.substr(t.length).trim();if(!i)return;switch(t){case"author":a=i;break;case"author-time":u=(new Date).getTime()-1e3*parseInt(i),c=new Date(1e3*parseInt(i)).toLocaleDateString();break;case"author-mail":h=i;break;case"summary":n=f(i)}}}));const m={file:e,line:t,subject:n,body:"",hash:r,author:a,date:c,email:h,relativeDate:(0,l.getDateTimeFormat)(u),stat:""};if(this.lineIsUncommit(m))return m;const g=(await this._exec(["show",`--format=%h${d}%ar${d}%b${d}`,"--stat",`${r}`],i.root)).split(d);return m.hash=g[0]??"",m.relativeDate=g[1]??"",m.body=g[2]?.trim()??"",m.stat=" "+g[3]?.trim(),m}lineIsUncommit(e){return!e||"Not Committed Yet"===e.author}_scanFolder(e,t){let i=0;return s.readdirSync(e,{withFileTypes:!0}).filter((e=>e.isDirectory())).forEach((async s=>{".git"===s.name?(this.getGitRepo(e),i++):t&&(i+=this._scanFolder(o.join(e,s.name)))})),i}async _getRemoteUrl(e){let t=(await this._exec(["remote"],e)).split(/\r?\n/g);const i=t.find((e=>"upstream"===e))||t.find((e=>"origin"===e));if(!i)return"";let o=(await this._exec(["remote","get-url","--push",i],e)).trim();o.startsWith("git@")&&(o=o.replace(":","/").replace("git@","https://"));let s=o.replace(/\.git$/g,"");return s.search(/\.(com|org|net|io|cloud)\//g)>0?s:(c.Tracer.info("Remote URL: "+o),s.replace(/:\/\/.*?\//g,"://github.com/"))}async _exec(e,t){const i=Date.now(),o=this._gitPath;try{const s=await new Promise(((i,s)=>{const r=(0,a.spawn)(o,e,{cwd:t});r.stdout.setEncoding("utf8"),r.stderr.setEncoding("utf8");let n="",c="";r.stdout.on("data",(e=>{n+=e})),r.stderr.on("data",(e=>{c+=e})),r.on("error",s).on("close",(e=>{0===e?i(n):s(c)}))}));return c.Tracer.verbose(`git command: ${o} ${e}. Output size: ${s.length} (${Date.now()-i}ms) ${t}`),s}catch(s){throw c.Tracer.error(`git command failed: ${o} ${e} (${Date.now()-i}ms) ${t} ${s}`),s}}}t.GitService=p,p.NotCommitted="Not Committed Yet"},517:(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.HistoryViewProvider=void 0;const o=i(398),s=i(747),r=i(293),n=i(368),a=i(268),c=i(477).loadMessageBundle(i(928).join(__dirname,"historyViewProvider.ts")),l=new o.MarkdownString(c(0,null)),h=new o.MarkdownString(c(1,null)),d=new o.MarkdownString(c(2,null)),u=new o.MarkdownString(c(3,null));function m(){return o.window.visibleTextEditors.find((e=>e.document.uri.scheme===g.scheme))}class g{constructor(e,t,i){this._model=t,this._gitService=i,this._clickableProvider=new r.ClickableProvider(g.scheme),this._commitsCount=200,this._content="",this._logCount=0,this._currentLine=0,this._loadAll=!1,this._updating=!1,this._loadMoreClicked=!1,this._leftCount=0,this._totalCommitsCount=0,this._onDidChange=new o.EventEmitter,this._titleDecoration=o.window.createTextEditorDecorationType({color:new o.ThemeColor("githd.historyView.title")}),this._branchDecoration=o.window.createTextEditorDecorationType({color:new o.ThemeColor("githd.historyView.branch")}),this._fileDecoration=o.window.createTextEditorDecorationType({color:new o.ThemeColor("githd.historyView.filePath")}),this._subjectDecoration=o.window.createTextEditorDecorationType({color:new o.ThemeColor("githd.historyView.subject")}),this._hashDecoration=o.window.createTextEditorDecorationType({color:new o.ThemeColor("githd.historyView.hash")}),this._selectedHashDecoration=o.window.createTextEditorDecorationType({backgroundColor:new o.ThemeColor("merge.currentContentBackground"),isWholeLine:!0,overviewRulerColor:"darkgreen",overviewRulerLane:o.OverviewRulerLane.Full}),this._refDecoration=o.window.createTextEditorDecorationType({color:new o.ThemeColor("githd.historyView.ref")}),this._authorDecoration=o.window.createTextEditorDecorationType({color:new o.ThemeColor("githd.historyView.author")}),this._emailDecoration=o.window.createTextEditorDecorationType({color:new o.ThemeColor("githd.historyView.email")}),this._moreDecoration=o.window.createTextEditorDecorationType({color:new o.ThemeColor("githd.historyView.more")}),this._loadingDecoration=o.window.createTextEditorDecorationType({light:{after:{contentIconPath:(0,s.getIconUri)("loading","light")}},dark:{after:{contentIconPath:(0,s.getIconUri)("loading","dark")}}}),this._titleDecorationOptions=[],this._subjectDecorationOptions=[],this._hashDecorationOptions=[],this._refDecorationOptions=[],this._authorDecorationOptions=[],this._emailDecorationOptions=[],this._repoStatusBar=o.window.createStatusBarItem(void 0,1),this._expressStatusBar=o.window.createStatusBarItem(void 0,2),this._express=!1,a.Tracer.info("Creating history view"),o.commands.executeCommand("setContext","history.view.show",!1),e.subscriptions.push(o.workspace.registerTextDocumentContentProvider(g.scheme,this)),this._expressStatusBar.command="githd.setExpressMode",this._expressStatusBar.tooltip=c(4,null),this.express=this._model.configuration.expressMode,this.commitsCount=this._model.configuration.commitsCount,e.subscriptions.push(this._model.onDidChangeConfiguration((e=>{this.commitsCount=e.commitsCount,this._updateExpressStatusBar()}),null,e.subscriptions)),e.subscriptions.push(this._model.onDidChangeHistoryViewContext((e=>{a.Tracer.verbose("HistoryView: onDidChangeHistoryViewContext"),o.workspace.openTextDocument(g.defaultUri).then((async e=>{o.window.showTextDocument(e,{preview:!1,preserveFocus:!0}),this._loadMoreClicked=!1,await this._updateContent(!1),this._moveToTop(m())}))}))),e.subscriptions.push(this._gitService.onDidChangeGitRepositories((e=>{this._updateExpressStatusBar()}))),e.subscriptions.push(o.window.onDidChangeActiveTextEditor((e=>{e&&e.document.uri.scheme===g.scheme?(a.Tracer.verbose("HistoryView: onDidChangeActiveTextEditor"),this._updating||this._setDecorations(e),this.repo=this._model.historyViewContext?.repo?.root):this.repo=void 0}),null,e.subscriptions)),e.subscriptions.push(o.workspace.onDidChangeTextDocument((e=>{if(e.document.uri.scheme===g.scheme){a.Tracer.verbose("HistoryView: onDidChangeTextDocument");const t=(0,n.getTextEditor)(e.document);this._setDecorations(t),this._leftCount>0?this._updateContent(!1):(this._loadMoreClicked||this._moveToTop(t),this._updating=!1)}}),null,e.subscriptions)),e.subscriptions.push(o.workspace.onDidCloseTextDocument((e=>{e.uri.scheme===g.scheme&&(a.Tracer.verbose("HistoryView: onDidCloseTextDocument"),this._reset())}))),this._updateExpressStatusBar(),e.subscriptions.push(this._expressStatusBar,this._repoStatusBar,this._onDidChange,this._clickableProvider,this._titleDecoration,this._fileDecoration,this._subjectDecoration,this._hashDecoration,this._selectedHashDecoration,this._refDecoration,this._authorDecoration,this._emailDecoration,this._moreDecoration,this._branchDecoration,this._loadingDecoration),a.Tracer.info("History view created")}get onDidChange(){return this._onDidChange.event}set loadAll(e){this._loadAll=e}get express(){return this._express}set express(e){this._express=e}set commitsCount(e){[100,200,300,400,500,1e3].findIndex((t=>t===e))>=0&&(this._commitsCount=e)}set repo(e){e?(this._repoStatusBar.text="githd: Repository "+this.removeTrailingBackslash(e),this._repoStatusBar.show()):this._repoStatusBar.hide()}removeTrailingBackslash(e){return e.endsWith("\\")?e.slice(0,-1):e}provideTextDocumentContent(e){return a.Tracer.verbose(`HistoryView: provideTextDocumentContent length: ${this._content.length}`),this._content}_updateExpressStatusBar(){this._model.configuration.displayExpress&&this._gitService.getGitRepos().length>0?this._expressStatusBar.show():this._expressStatusBar.hide()}_update(){a.Tracer.info("HistoryView: _update"),this._onDidChange.fire(g.defaultUri)}async _updateContent(e){const t=this._model.historyViewContext;if(!t)return;a.Tracer.verbose(`HistoryView: left count ${this._leftCount}, current total count ${this._totalCommitsCount}, load more ${e}`),this._updating=!0,a.Tracer.info(`HistoryView: _updateContent. ${JSON.stringify(t)}`);const i=this._content,o=t.isStash??!1,s=0==this._leftCount;let r=this._express?50:25;if(s)if(e?(this._content=this._content.substring(0,this._content.length-3-1),this._content+="--------------------------------------------------------------\n\n",this._currentLine+=2):this._reset(),o||t.specifiedPath)r=1e4;else{const e=await this._gitService.getCommitsCount(t.repo,t.branch,t.author);let i=Math.min(e-this._logCount,this._commitsCount);this._loadAll&&(i=e-this._logCount),this._leftCount=Math.max(0,i-25),this._totalCommitsCount=e}else r=this._express?1500:300,r=Math.min(r,this._leftCount),this._leftCount=this._leftCount-r;const n=await this._gitService.getLogEntries(t.repo,this._express,this._logCount,r,t.branch,t.isStash,t.specifiedPath,t.line,t.author);if(0===n.length)return this._reset(),this._content=o?"No Stash":"No History",void this._update();let c="";s&&!e&&(this._reset(),c=await this._updateTitleInfo(t)),n.forEach((e=>{++this._logCount,c+=this._updateSubject(e.subject,t.repo.remoteUrl),c+=this._updateInfo(t,e,o),c+=this._updateStat(t,e),c+="\n",++this._currentLine})),0==this._leftCount&&(this._totalCommitsCount>this._logCount?c+=this._createClickableForMore():this._moreClickableRange=void 0,this._totalCommitsCount=0),this._content+=c,this._content==i?(this._setDecorations(m()),this._updating=!1):this._update(),this.repo=t.repo.root}async _updateTitleInfo(e){let t=e.isStash?"Git Stashes":"Git History";if((0,n.decorateWithoutWhitespace)(this._titleDecorationOptions,t,0,0),e.isStash)return this._currentLine+=2,t+" \n\n";if(e.specifiedPath){t+=" of ";let i=t.length;t+=await this._gitService.getGitRelativePath(e.specifiedPath),this._fileDecorationRange=new o.Range(this._currentLine,i,this._currentLine,t.length),e.line&&(t+=" at line "+e.line)}t+=" on ",this._branchDecorationRange=new o.Range(0,t.length,0,t.length+e.branch.length),this._clickableProvider.addClickable({range:this._branchDecorationRange,callback:()=>o.commands.executeCommand("githd.viewBranchHistory",e),getHoverMessage:()=>l}),t+=e.branch,t+=" by ";let i=e.author;i||(t+="all ",i="authors");let s=t.length;t+=i;let r=new o.Range(this._currentLine,s,this._currentLine,t.length);return this._emailDecorationOptions.push(r),this._clickableProvider.addClickable({range:r,callback:()=>o.commands.executeCommand("githd.viewAuthorHistory"),getHoverMessage:()=>h}),this._currentLine+=2,t+" \n\n"}_updateSubject(e,t){if(t.indexOf("github.com")>0){const[i,s]=(0,n.getPullRequest)(e);if(i){const e=t+"/pull/"+i.substring(1);this._clickableProvider.addClickable({range:new o.Range(this._currentLine,s,this._currentLine,s+i.length),callback:()=>{o.env.openExternal(o.Uri.parse(e))},getHoverMessage:()=>u})}}return(0,n.decorateWithoutWhitespace)(this._subjectDecorationOptions,e,this._currentLine,0),++this._currentLine,e+"\n"}_updateInfo(e,t,i){let s=t.hash,r=new o.Range(this._currentLine,0,this._currentLine,s.length);if(this._hashDecorationOptions.push(r),this._clickableProvider.addClickable({range:r,callback:()=>{this._model.filesViewContext={repo:e.repo,isStash:i,leftRef:void 0,rightRef:t.hash,specifiedPath:e.specifiedPath,focusedLineInfo:t.lineInfo}},clickedDecorationType:this._selectedHashDecoration,getHoverMessage:async()=>{const s=new o.MarkdownString,r=await this._gitService.getCommitDetails(e.repo,t.hash,i);return s.appendCodeblock(r,"txt"),s}}),t.ref){let e=s.length;s+=t.ref,(0,n.decorateWithoutWhitespace)(this._refDecorationOptions,t.ref,this._currentLine,e)}if(t.author){s+=" by ";let e=s.length;s+=t.author,(0,n.decorateWithoutWhitespace)(this._authorDecorationOptions,t.author,this._currentLine,e)}if(t.email){s+=" <";let e=s.length;s+=t.email,r=new o.Range(this._currentLine,e,this._currentLine,s.length),this._emailDecorationOptions.push(r),s+=">"}return t.date&&(s+=", ",s+=t.date),++this._currentLine,s+"\n"}_updateStat(e,t){if(!t.stat)return"";let i=t.stat;return e.specifiedPath&&(i=t.stat.replace("1 file changed, ","")),++this._currentLine,i+"\n"}_createClickableForMore(){return this._moreClickableRange=new o.Range(this._currentLine,0,this._currentLine,3),this._clickableProvider.addClickable({range:this._moreClickableRange,callback:()=>{this._moreClickableRange&&(this._clickableProvider.removeClickable(this._moreClickableRange),this._moreClickableRange=void 0),this._loadMoreClicked=!0,this._updateContent(!0)},getHoverMessage:()=>d}),"··· "}_moveToTop(e){a.Tracer.verbose("HistoryView: _moveToTop"),e&&(e.selection=new o.Selection(0,0,0,0),e.revealRange(new o.Range(0,0,0,0)))}_setDecorations(e){if(e?.document.uri.scheme===g.scheme){if(a.Tracer.verbose(`HistoryView: _setDecorations cnontent length: ${this._content.length}, _subjectDecorationOptions size: ${this._subjectDecorationOptions.length}`),!this._content)return a.Tracer.verbose("HistoryView: _loadingDecoration used"),void e.setDecorations(this._loadingDecoration,[new o.Range(0,0,0,1)]);e.selection=new o.Selection(0,0,0,0),e.setDecorations(this._loadingDecoration,[]),e.setDecorations(this._titleDecoration,this._titleDecorationOptions),e.setDecorations(this._fileDecoration,this._fileDecorationRange?[this._fileDecorationRange]:[]),e.setDecorations(this._branchDecoration,this._branchDecorationRange?[this._branchDecorationRange]:[]),e.setDecorations(this._subjectDecoration,this._subjectDecorationOptions),e.setDecorations(this._hashDecoration,this._hashDecorationOptions),e.setDecorations(this._refDecoration,this._refDecorationOptions),e.setDecorations(this._authorDecoration,this._authorDecorationOptions),e.setDecorations(this._emailDecoration,this._emailDecorationOptions),e.setDecorations(this._moreDecoration,this._moreClickableRange?[this._moreClickableRange]:[])}else a.Tracer.warning(`HistoryView: try to set decoration to wrong scheme: ${e?e.document.uri.scheme:""}`)}_clearDecorations(){a.Tracer.verbose("HistoryView: _clearDecorations"),this._clickableProvider.clear(),this._moreClickableRange=void 0,this._titleDecorationOptions=[],this._fileDecorationRange=void 0,this._branchDecorationRange=void 0,this._subjectDecorationOptions=[],this._hashDecorationOptions=[],this._refDecorationOptions=[],this._authorDecorationOptions=[],this._emailDecorationOptions=[]}_reset(){a.Tracer.verbose("HistoryView: _reset"),this._clearDecorations(),this._content="",this._logCount=0,this._currentLine=0}}t.HistoryViewProvider=g,g.scheme="githd-logs",g.defaultUri=o.Uri.parse(g.scheme+"://authority/Git History")},747:(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.getIconUri=void 0;const o=i(928),s=i(398),r=o.join(o.dirname(__dirname),"resources","icons");t.getIconUri=function(e,t){return s.Uri.file(o.join(r,t,`${e}.svg`))}},153:(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.InfoViewProvider=void 0;const o=i(398),s=i(368);class r{constructor(e,t,i){this._infoDecoration=o.window.createTextEditorDecorationType({color:new o.ThemeColor("githd.infoView.content")}),this._pathDecoration=o.window.createTextEditorDecorationType({color:new o.ThemeColor("githd.infoView.path")}),this._oldLineDecoration=o.window.createTextEditorDecorationType({color:new o.ThemeColor("githd.infoView.old")}),this._newLineDecoration=o.window.createTextEditorDecorationType({color:new o.ThemeColor("githd.infoView.new")}),this._onDidChange=new o.EventEmitter,e.subscriptions.push(o.workspace.registerTextDocumentContentProvider(r.scheme,this)),e.subscriptions.push(o.window.onDidChangeActiveTextEditor((e=>{e&&e.document.uri.scheme===r.scheme&&this._decorate(e)}),null,e.subscriptions)),e.subscriptions.push(o.workspace.onDidChangeTextDocument((e=>{e.document.uri.scheme===r.scheme&&this._decorate((0,s.getTextEditor)(e.document))}),null,e.subscriptions)),e.subscriptions.push(t.onDidChangeFilesViewContext((async e=>{e?.rightRef&&!e.leftRef&&this.update(await i.getCommitDetails(e?.repo,e.rightRef,e.isStash??!1))}),null,e.subscriptions)),e.subscriptions.push(this._onDidChange,this._infoDecoration,this._pathDecoration,this._oldLineDecoration,this._newLineDecoration)}get onDidChange(){return this._onDidChange.event}provideTextDocumentContent(e){return this._content??""}update(e){this._content=e,this._onDidChange.fire(r.defaultUri)}_decorate(e){if(e&&this._content){let t=[],i=[],o=[],r=[],n=!1,a=0;this._content.split(/\r?\n/g).forEach((e=>{"diff --"==e.substring(0,6)?(n=!0,(0,s.decorateWithoutWhitespace)(i,e,a,0)):"--- "==e.substring(0,3)||"+++ "==e.substring(0,3)?(0,s.decorateWithoutWhitespace)(i,e,a,0):"-"==e[0]?(0,s.decorateWithoutWhitespace)(o,e,a,0):"+"==e[0]?(0,s.decorateWithoutWhitespace)(r,e,a,0):n||(0,s.decorateWithoutWhitespace)(t,e,a,0),++a})),e.setDecorations(this._infoDecoration,t),e.setDecorations(this._pathDecoration,i),e.setDecorations(this._oldLineDecoration,o),e.setDecorations(this._newLineDecoration,r)}}}t.InfoViewProvider=r,r.scheme="githd-line",r.defaultUri=o.Uri.parse(r.scheme+"://authority/Commit Info")},544:(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.Model=void 0;const o=i(398),s=i(268);function r(){return{withFolder:o.workspace.getConfiguration("githd.explorerView").get("withFolder"),commitsCount:o.workspace.getConfiguration("githd.logView").get("commitsCount"),expressMode:o.workspace.getConfiguration("githd.logView").get("expressMode"),displayExpress:o.workspace.getConfiguration("githd.logView").get("displayExpressStatus"),blameEnabled:o.workspace.getConfiguration("githd.blameView").get("enabled"),disabledInEditor:o.workspace.getConfiguration("githd.editor").get("disabled"),traceLevel:o.workspace.getConfiguration("githd").get("traceLevel")}}t.Model=class{constructor(e,t){this._gitService=t,this._onDidChangeConfiguration=new o.EventEmitter,this._onDidChangeFilesViewContext=new o.EventEmitter,this._onDidChangeHistoryViewContext=new o.EventEmitter,this._config=r(),s.Tracer.level=this._config.traceLevel,o.commands.executeCommand("setContext","disableInEditor",this._config.disabledInEditor),e.subscriptions.push(o.workspace.onDidChangeConfiguration((()=>{let e=r();e.withFolder===this._config.withFolder&&e.commitsCount===this._config.commitsCount&&e.expressMode===this._config.expressMode&&e.displayExpress===this._config.displayExpress&&e.blameEnabled===this._config.blameEnabled&&e.disabledInEditor===this._config.disabledInEditor&&e.traceLevel===this._config.traceLevel||(s.Tracer.info(`Model: configuration updated ${JSON.stringify(e)}`),this._config=e,this._onDidChangeConfiguration.fire(e),s.Tracer.level=e.traceLevel,o.commands.executeCommand("setContext","disableInEditor",e.disabledInEditor))}),null,e.subscriptions)),e.subscriptions.push(o.workspace.onDidChangeWorkspaceFolders((e=>{this._gitService.updateGitRoots(o.workspace.workspaceFolders)}),null,e.subscriptions)),this._gitService.updateGitRoots(o.workspace.workspaceFolders),e.subscriptions.push(this._onDidChangeConfiguration,this._onDidChangeFilesViewContext,this._onDidChangeHistoryViewContext)}get configuration(){return this._config}get filesViewContext(){return this._filesViewContext}set filesViewContext(e){s.Tracer.info(`Model: set filesViewContext - ${JSON.stringify(e)}`),this._filesViewContext&&this._filesViewContext.leftRef==e?.leftRef&&this._filesViewContext.rightRef==e?.rightRef&&this._filesViewContext.specifiedPath==e?.specifiedPath&&this._filesViewContext.focusedLineInfo==e?.focusedLineInfo||(this._filesViewContext=e,o.commands.executeCommand("setContext","history.view.show",!0),this._onDidChangeFilesViewContext.fire(this._filesViewContext)),o.commands.executeCommand("committedFiles.focus")}get historyViewContext(){return this._historyViewContext}async setHistoryViewContext(e){s.Tracer.info(`Model: set historyViewContext - ${JSON.stringify(e)}`),this._historyViewContext=e,this._historyViewContext&&!this._historyViewContext?.branch&&(this._historyViewContext.branch=await this._gitService.getCurrentBranch(e?.repo)??""),this._onDidChangeHistoryViewContext.fire(this._historyViewContext)}get onDidChangeConfiguration(){return this._onDidChangeConfiguration.event}get onDidChangeFilesViewContext(){return this._onDidChangeFilesViewContext.event}get onDidChangeHistoryViewContext(){return this._onDidChangeHistoryViewContext.event}}},268:(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.Tracer=void 0;const o=i(398);var s;!function(e){e[e.Silent=0]="Silent",e[e.Error=1]="Error",e[e.Warning=2]="Warning",e[e.Info=3]="Info",e[e.Verbose=4]="Verbose"}(s||(s={}));class r{static set level(e){this._level="error"===e?s.Error:"warning"===e?s.Warning:"info"===e?s.Info:"verbose"===e?s.Verbose:s.Silent}static verbose(e){this._log(e,s.Verbose)}static info(e){this._log(e,s.Info)}static warning(e){this._log(e,s.Warning)}static error(e){this._log(e,s.Error)}static get output(){return this._output||(this._output=o.window.createOutputChannel("GitHD")),this._output}static get timestamp(){return(new Date).toISOString().split("T")[1].replace("Z","")}static _log(e,t){this._level>=t&&(e=`[${this.timestamp}][${s[t]}] ${e}`,this._debugging?console.log("[GitHD]",e):this.output.appendLine(e))}}t.Tracer=r,r._level=s.Silent,r._debugging=function(){const e=process.execArgv;return e&&e.some((e=>e.startsWith("--inspect")))}()},368:(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.getDateTimeFormat=t.getPullRequest=t.getTextEditor=t.decorateWithoutWhitespace=void 0;const o=i(398);t.decorateWithoutWhitespace=function(e,t,i,s){let r=0,n=!0,a=0;for(;a<t.length;++a)" "===t[a]||"\t"===t[a]||"\n"===t[a]?n||(n=!0,e.push(new o.Range(i,s+r,i,s+a))):n&&(n=!1,r=a);n||e.push(new o.Range(i,s+r,i,s+a))},t.getTextEditor=function(e){return o.window.visibleTextEditors.find((t=>t.document===e))},t.getPullRequest=function(e){const t=e.match(/#[0-9]+/g);return t?[t[0],e.indexOf(t[0])]:["",0]},t.getDateTimeFormat=function(e){if(e<60)return e>1?`${e} seconds ago`:"1 second ago";const t=e/60;if(t<60)return t>1?`${Math.floor(t)} minutes ago`:"1 minute ago";const i=e/3600;if(i<24)return i>1?`${Math.floor(i)} hours ago`:"1 hour ago";const o=e/3600/24;if(o<30)return o>1?`${Math.floor(o)} days ago`:"1 day ago";const s=e/3600/24/30;if(s<12)return s>1?`${Math.floor(s)} months ago`:"1 month ago";const r=e/3600/24/30/12;return r?r>1?`${Math.floor(r)} years ago`:"1 year ago":""}},526:(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.config=t.loadMessageBundle=t.localize=t.format=t.setPseudo=t.isPseudo=t.isDefined=t.BundleFormat=t.MessageFormat=void 0;var o,s,r,n=i(124);function a(e){return void 0!==e}function c(e,i){return t.isPseudo&&(e="［"+e.replace(/[aouei]/g,"$&$&")+"］"),0===i.length?e:e.replace(/\{(\d+)\}/g,(function(e,t){var o=t[0],s=i[o],r=e;return"string"==typeof s?r=s:"number"!=typeof s&&"boolean"!=typeof s&&null!=s||(r=String(s)),r}))}(r=t.MessageFormat||(t.MessageFormat={})).file="file",r.bundle="bundle",r.both="both",(s=t.BundleFormat||(t.BundleFormat={})).standalone="standalone",s.languagePack="languagePack",function(e){e.is=function(e){var t=e;return t&&a(t.key)&&a(t.comment)}}(o||(o={})),t.isDefined=a,t.isPseudo=!1,t.setPseudo=function(e){t.isPseudo=e},t.format=c,t.localize=function(e,t){for(var i=[],o=2;o<arguments.length;o++)i[o-2]=arguments[o];return c(t,i)},t.loadMessageBundle=function(e){return(0,n.default)().loadMessageBundle(e)},t.config=function(e){return(0,n.default)().config(e)}},124:(e,t)=>{var i;function o(){if(void 0===i)throw new Error("No runtime abstraction layer installed");return i}Object.defineProperty(t,"__esModule",{value:!0}),function(e){e.install=function(e){if(void 0===e)throw new Error("No runtime abstraction layer provided");i=e}}(o||(o={})),t.default=o},477:(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.config=t.loadMessageBundle=t.BundleFormat=t.MessageFormat=void 0;var o=i(928),s=i(896),r=i(124),n=i(526),a=i(526);Object.defineProperty(t,"MessageFormat",{enumerable:!0,get:function(){return a.MessageFormat}}),Object.defineProperty(t,"BundleFormat",{enumerable:!0,get:function(){return a.BundleFormat}});var c,l,h=Object.prototype.toString;function d(e){return"[object String]"===h.call(e)}function u(e){return JSON.parse(s.readFileSync(e,"utf8"))}function m(e){return function(t,i){for(var o,s=[],r=2;r<arguments.length;r++)s[r-2]=arguments[r];return o=t,"[object Number]"===h.call(o)?t>=e.length?void console.error("Broken localize call found. Index out of bounds. Stacktrace is\n: ".concat(new Error("").stack)):(0,n.format)(e[t],s):d(i)?(console.warn("Message ".concat(i," didn't get externalized correctly.")),(0,n.format)(i,s)):void console.error("Broken localize call found. Stacktrace is\n: ".concat(new Error("").stack))}}function g(e,t){return c[e]=t,t}function f(e){try{return function(e){var t=u(o.join(e,"nls.metadata.json")),i=Object.create(null);for(var s in t){var r=t[s];i[s]=r.messages}return i}(e)}catch(e){return void console.log("Generating default bundle from meta data failed.",e)}}function p(e,t){var i;if(!0===l.languagePackSupport&&void 0!==l.cacheRoot&&void 0!==l.languagePackId&&void 0!==l.translationsConfigFile&&void 0!==l.translationsConfig)try{i=function(e,t){var i,r,n,a=o.join(l.cacheRoot,"".concat(e.id,"-").concat(e.hash,".json")),c=!1,h=!1;try{return i=JSON.parse(s.readFileSync(a,{encoding:"utf8",flag:"r"})),r=a,n=new Date,s.utimes(r,n,n,(function(){})),i}catch(e){if("ENOENT"===e.code)h=!0;else{if(!(e instanceof SyntaxError))throw e;console.log("Syntax error parsing message bundle: ".concat(e.message,".")),s.unlink(a,(function(e){e&&console.error("Deleting corrupted bundle ".concat(a," failed."))})),c=!0}}if(i=function(e,t){var i=l.translationsConfig[e.id];if(i){var s=u(i).contents,r=u(o.join(t,"nls.metadata.json")),n=Object.create(null);for(var a in r){var c=r[a],h=s["".concat(e.outDir,"/").concat(a)];if(h){for(var m=[],g=0;g<c.keys.length;g++){var f=c.keys[g],p=h[d(f)?f:f.key];void 0===p&&(p=c.messages[g]),m.push(p)}n[a]=m}else n[a]=c.messages}return n}}(e,t),!i||c)return i;if(h)try{s.writeFileSync(a,JSON.stringify(i),{encoding:"utf8",flag:"wx"})}catch(e){if("EEXIST"===e.code)return i;throw e}return i}(e,t)}catch(e){console.log("Load or create bundle failed ",e)}if(!i){if(l.languagePackSupport)return f(t);var r=function(e){for(var t=l.language;t;){var i=o.join(e,"nls.bundle.".concat(t,".json"));if(s.existsSync(i))return i;var r=t.lastIndexOf("-");t=r>0?t.substring(0,r):void 0}if(void 0===t&&(i=o.join(e,"nls.bundle.json"),s.existsSync(i)))return i}(t);if(r)try{return u(r)}catch(e){console.log("Loading in the box message bundle failed.",e)}i=f(t)}return i}function _(e){if(!e)return n.localize;var t=o.extname(e);if(t&&(e=e.substr(0,e.length-t.length)),l.messageFormat===n.MessageFormat.both||l.messageFormat===n.MessageFormat.bundle){var i=function(e){for(var t,i=o.dirname(e);t=o.join(i,"nls.metadata.header.json"),!s.existsSync(t);){var r=o.dirname(i);if(r===i){t=void 0;break}i=r}return t}(e);if(i){var r=o.dirname(i),a=c[r];if(void 0===a)try{var h=JSON.parse(s.readFileSync(i,"utf8"));try{var d=p(h,r);a=g(r,d?{header:h,nlsBundle:d}:null)}catch(e){console.error("Failed to load nls bundle",e),a=g(r,null)}}catch(e){console.error("Failed to read header file",e),a=g(r,null)}if(a){var f=e.substr(r.length+1).replace(/\\/g,"/"),_=a.nlsBundle[f];return void 0===_?(console.error("Messages for file ".concat(e," not found. See console for details.")),function(){return"Messages not found."}):m(_)}}}if(l.messageFormat===n.MessageFormat.both||l.messageFormat===n.MessageFormat.file)try{var w=u(function(e){var t;if(l.cacheLanguageResolution&&t);else{if(n.isPseudo||!l.language)t=".nls.json";else for(var i=l.language;i;){var o=".nls."+i+".json";if(s.existsSync(e+o)){t=o;break}var r=i.lastIndexOf("-");r>0?i=i.substring(0,r):(t=".nls.json",i=null)}l.cacheLanguageResolution}return e+t}(e));return Array.isArray(w)?m(w):(0,n.isDefined)(w.messages)&&(0,n.isDefined)(w.keys)?m(w.messages):(console.error("String bundle '".concat(e,"' uses an unsupported format.")),function(){return"File bundle has unsupported format. See console for details"})}catch(e){"ENOENT"!==e.code&&console.error("Failed to load single file bundle",e)}return console.error("Failed to load message bundle for file ".concat(e)),function(){return"Failed to load message bundle. See console for details."}}function w(e){return e&&(d(e.locale)&&(l.locale=e.locale.toLowerCase(),l.language=l.locale,c=Object.create(null)),void 0!==e.messageFormat&&(l.messageFormat=e.messageFormat),e.bundleFormat===n.BundleFormat.standalone&&!0===l.languagePackSupport&&(l.languagePackSupport=!1)),(0,n.setPseudo)("pseudo"===l.locale),_}!function(){if(l={locale:void 0,language:void 0,languagePackSupport:!1,cacheLanguageResolution:!0,messageFormat:n.MessageFormat.bundle},d(process.env.VSCODE_NLS_CONFIG))try{var e=JSON.parse(process.env.VSCODE_NLS_CONFIG),t=void 0;if(e.availableLanguages){var i=e.availableLanguages["*"];d(i)&&(t=i)}if(d(e.locale)&&(l.locale=e.locale.toLowerCase()),void 0===t?l.language=l.locale:"en"!==t&&(l.language=t),function(e){return!0===e||!1===e}(e._languagePackSupport)&&(l.languagePackSupport=e._languagePackSupport),d(e._cacheRoot)&&(l.cacheRoot=e._cacheRoot),d(e._languagePackId)&&(l.languagePackId=e._languagePackId),d(e._translationsConfigFile)){l.translationsConfigFile=e._translationsConfigFile;try{l.translationsConfig=u(l.translationsConfigFile)}catch(t){if(e._corruptedFile){var r=o.dirname(e._corruptedFile);s.exists(r,(function(t){t&&s.writeFile(e._corruptedFile,"corrupted","utf8",(function(e){console.error(e)}))}))}}}}catch(e){}(0,n.setPseudo)("pseudo"===l.locale),c=Object.create(null)}(),t.loadMessageBundle=_,t.config=w,r.default.install(Object.freeze({loadMessageBundle:_,config:w}))},398:e=>{e.exports=require("vscode")},613:e=>{e.exports=require("assert")},317:e=>{e.exports=require("child_process")},896:e=>{e.exports=require("fs")},857:e=>{e.exports=require("os")},928:e=>{e.exports=require("path")}},t={};function i(o){var s=t[o];if(void 0!==s)return s.exports;var r=t[o]={exports:{}};return e[o].call(r.exports,r,r.exports,i),r.exports}var o={};(()=>{var e=o;Object.defineProperty(e,"__esModule",{value:!0}),e.deactivate=e.activate=void 0;const t=i(477);t.config({messageFormat:t.MessageFormat.both,bundleFormat:t.BundleFormat.standalone})(i(928).join(__dirname,"extension.ts"));const s=i(544),r=i(414),n=i(875),a=i(586),c=i(517),l=i(210),h=i(153),d=i(834);e.activate=function(e){const t=new r.GitService(e),i=new s.Model(e,t);e.subscriptions.push(new a.default);const o=new c.HistoryViewProvider(e,i,t),u=new h.InfoViewProvider(e,i,t);new l.ExplorerViewProvider(e,i,t);const m=new d.BlameViewProvider(e,i,t);new n.CommandCenter(e,i,t,o,u,m)},e.deactivate=function(){}})(),module.exports=o})();
//# sourceMappingURL=extension.js.map